Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/quest_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 157, y = 176.31, z = 5, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["check_pass_south"] = 
{
	active = true, 
	effect_radius = 11, 
	position = { x = 116.3, y = 122.8, z = 36.8, f = 1.0}, 
	priority = 1, 
	think = "tf_check_pass_south", 
	type = "quest", 
}

Triggers["check_pass_west"] = 
{
	active = true, 
	effect_radius = 15, 
	position = { x = 131.3, y = 188.5, z = 46.2, f = 1.0}, 
	priority = 1, 
	think = "tf_check_pass_west", 
	type = "quest", 
}

Triggers["emergency_exit"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_emergency_exit", 
	type = "quest", 
}

Triggers["mission"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_mission", 
	type = "quest", 
}

Triggers["kill_them_all"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_kill_them_all", 
	type = "quest", 
}

trigger_functions =
{
tf_check_pass_south = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,PLAYER) ) then
			Triggers["mission"].active = true
			trigger.active = false
		end
	end
end,
tf_check_pass_west = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,PLAYER) ) then
			Triggers["mission"].active = true
			trigger.active = false
		end
	end
end,
tf_emergency_exit = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		finishMission(false)
		trigger.active = false
	end
end,
tf_mission = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if ( getGVAR("spawn_chief_mv") == _YES ) then
			if (Sectors.mountain_village.check_passed == false) then
				if ( ENEMY ~= checkRelations(PLAYER, BUTSI) ) then			
					startDlg("check","tribe_1",getClosestMerc("tribe_1", CUR_MISSION.Mercs))
					Sectors.mountain_village.check_passed = true
				end
			end
		end

		trigger.active = false
	end
end,
tf_kill_them_all = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		changeLocalRelations(ENEMY, BUTSI)		
		trigger.active = false
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
--
-- quest watcher trigger
--
tf_quest_watcher = CommonTriggers.quest_watcher,
}
